﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private SchoolYearBL _SchoolYearBL = null;

        public SchoolYearBL SchoolYear
        {
            get
            {
                if (_SchoolYearBL == null)
                {
                    _SchoolYearBL = new SchoolYearBL(this);
                }

                return _SchoolYearBL;
            }
        }

        public class SchoolYearBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public SchoolYearBL(ZSBELearning BL) : base(BL) { }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.SchoolYear.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public List<BO.SchoolYear> Restore()
            {
                BO.SchoolYear.Search _search = new BO.SchoolYear.Search();
                return BLP.DAL.SchoolYear.Restore(_search);
            }

            public BO.SchoolYear RestoreActive()
            {
                BO.SchoolYear.Search _search = new BO.SchoolYear.Search();
                _search.IsActive = true;

                BO.SchoolYear _activeSchoolYear = BLP.DAL.SchoolYear.RestoreTopOne(_search);
                if (_activeSchoolYear == null)
                {
                    _activeSchoolYear = New(String.Format("{0}/{1}",DateTime.Now.Year,DateTime.Now.Year +1));
                }
                return _activeSchoolYear;
            }

            public BO.SchoolYear Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.SchoolYear _SchoolYear = null;

                if ((BO != null) && (BO.ID.HasValue))
                {
                    _SchoolYear = Restore(BO.ID);
                }

                return _SchoolYear;
            }

            public BO.SchoolYear Restore(long? ID)
            {
                BO.SchoolYear _SchoolYear = null;

                if (ID.HasValue)
                {
                    _SchoolYear = BLP.DAL.SchoolYear.Restore(ID);
                }

                return _SchoolYear;
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.SchoolYear SchoolYear)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {

                    if (SchoolYear == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        if (SchoolYear.ID.HasValue)
                        {
                            _methodResult.SetSuccess = BLP.DAL.SchoolYear.Update(SchoolYear);
                        }
                        else
                        {
                            _methodResult.SetSuccess = BLP.DAL.SchoolYear.Create(SchoolYear);
                        }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public BO.SchoolYear New(string Name)
            {
                BO.SchoolYear _new = null;

                BO.SchoolYear.Search _search = new BO.SchoolYear.Search();
                _search.IsActive = true;


                List<BO.SchoolYear> _listSchoolYear = BLP.DAL.SchoolYear.Restore(_search);

                if (!String.IsNullOrEmpty(Name))
                {
                    _new = BLP.DAL.SchoolYear.New();
                    _new.IsActive = true;
                    _new.IsClosed = false;
                    _new.Name = Name;
                    _new.Weight = BLP.DAL.SchoolYear.Count() + 1;

                    Save(_new);
                }

                foreach(BO.SchoolYear _loopSchoolYear in _listSchoolYear)
                {
                    _loopSchoolYear.IsActive = false;
                    Save(_loopSchoolYear);
                }

                return _new;
            }

            public Gemini.Core.BL.Base.MethodResult Close(BO.SchoolYear SchoolYear)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
#warning Uzupełnic kod
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.SchoolYear SchoolYear)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    _methodResult.SetSuccess = BLP.DAL.SchoolYear.Remove(SchoolYear);

#warning Uzupełnic kod dla School Yera BL Remove
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            private CacheBL _CacheBL = null;

            public CacheBL Cache
            {
                get
                {
                    if (_CacheBL == null)
                    {
                        _CacheBL = new CacheBL(this.BLP);
                    }
                    return _CacheBL;
                }
            }

            public class CacheBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                private Dictionary<long,BO.SchoolYear> _cacheDictionary = null;

                protected Dictionary<long, BO.SchoolYear>  CacheDictionary
                {
                    get
                    {
                        if (_cacheDictionary == null)
                        {
                            _cacheDictionary = new Dictionary<long, BO.SchoolYear>();

                            List<BO.SchoolYear> _listSchoolYear = BLP.SchoolYear.Restore();

                            foreach(BO.SchoolYear _loopSchoolYear in _listSchoolYear)
                            {
                                _cacheDictionary.Add(_loopSchoolYear.ID.Value, _loopSchoolYear);
                            }
                        }

                        return _cacheDictionary;
                    }
                }

                public CacheBL(ZSBELearning BL) : base(BL) { }

                public BO.SchoolYear Restore(BO.Class Class)
                {
                    BO.SchoolYear _schoolYear = null;
                    if ((Class != null) && (Class.SchoolYearID.HasValue))
                    {
                        _schoolYear = CacheDictionary[Class.SchoolYearID.Value];
                    }

                    return _schoolYear;
                }

                public string RestoreName(BO.Class Class)
                {
                    string _schoolYearName = string.Empty;

                    BO.SchoolYear _schoolYear = Restore(Class);

                    if (_schoolYear != null)
                    {
                        _schoolYearName = _schoolYear.Name;
                    }

                    return _schoolYearName;
                }
            }
        }
    }
}
